// Generated by CoffeeScript 1.10.0
(function() {
  var FILENAME, PLATFORM, addSource, app, debug, debugOld, doNothing, electron, error, findChromeFlashPath, findSystemFlashPath, flashSources, fs, getAllChromeFlashVersions, getFlashVersion, getNewerVersion, getPath, join, load, log, reVerNum, ref, resolve, usingIndex, validatePath;

  electron = require('electron');

  app = process.type === 'browser' ? electron.app : electron.remote.app;

  ref = require('path'), join = ref.join, resolve = ref.resolve;

  fs = require('fs');

  doNothing = function() {};

  log = error = doNothing;

  debugOld = function(logFunc, errFunc) {
    if (typeof logFunc === 'function') {
      log = error = logFunc;
    } else {
      log = console.log.bind(console);
      error = console.error.bind(console);
    }
    if (typeof errFunc === 'function') {
      error = errFunc;
    }
    log('Debugging Flash Loader');
    log('[DEPRECATED] `debug(logFunc, errFunc)` is deprecated. Please call `debug(options)` instead.');
    return this;
  };

  debug = function(options) {
    if (options == null) {
      options = {};
    }
    if (typeof options !== 'object') {
      return debugOld.apply(this, arguments);
    }
    if (options.enable == null) {
      options.enable = true;
    }
    if (options.enable) {
      log = options.log != null ? options.log : console.log.bind(console);
      error = options.error != null ? options.error : console.error.bind(console);
    } else {
      log = error = doNothing;
    }
    log('Debugging Flash Loader');
    return this;
  };

  PLATFORM = process.platform;

  FILENAME = (function() {
    switch (PLATFORM) {
      case 'darwin':
        return 'PepperFlashPlayer.plugin';
      case 'linux':
        return 'libpepflashplayer.so';
      case 'win32':
        return 'pepflashplayer.dll';
    }
  })();

  validatePath = function(path) {
    var error1, p;
    p = path;
    try {
      fs.accessSync(p);
      if (!p.endsWith(FILENAME)) {
        p = join(path, FILENAME);
        fs.accessSync(p);
      }
    } catch (error1) {
      return null;
    }
    return p;
  };

  reVerNum = /(\d+)\.(\d+)\.(\d+)\.(\d+)/;

  getNewerVersion = function(ver1, ver2) {
    var i, j, v1, v2;
    v1 = reVerNum.exec(ver1);
    v2 = reVerNum.exec(ver2);
    if (!v1) {
      if (v2) {
        return ver2;
      } else {
        return '';
      }
    }
    for (i = j = 1; j <= 4; i = ++j) {
      if (v1[i] === v2[i]) {
        continue;
      }
      if (parseInt(v1[i]) > parseInt(v2[i])) {
        return ver1;
      } else {
        return ver2;
      }
    }
    return ver1;
  };

  findChromeFlashPath = function(getAll) {
    var chromeFlashPath, chromeVer, chromeVersions, chromeVersionsDir, error1, flashDir, flashVersions, internalFlashDir, j, k, len, len1, paths, ver;
    if (getAll == null) {
      getAll = false;
    }
    switch (PLATFORM) {
      case 'darwin':
        if (getAll) {
          paths = [];
          try {
            flashDir = join(app.getPath('appData'), 'Google/Chrome/PepperFlash');
            flashVersions = fs.readdirSync(flashDir);
            for (j = 0, len = flashVersions.length; j < len; j++) {
              ver = flashVersions[j];
              paths.push(join(flashDir, ver));
            }
          } catch (undefined) {}
        }
        try {
          chromeVersionsDir = '/Applications/Google Chrome.app/Contents/Versions';
          internalFlashDir = 'Google Chrome Framework.framework/Internet Plug-Ins/PepperFlash';
          chromeVersions = fs.readdirSync(chromeVersionsDir);
          if (!getAll) {
            if (chromeVersions.length === 0) {
              return null;
            }
            chromeVer = chromeVersions.reduce(getNewerVersion);
            chromeFlashPath = join(chromeVersionsDir, chromeVer, internalFlashDir);
            fs.accessSync(chromeFlashPath);
            return chromeFlashPath;
          } else {
            for (k = 0, len1 = chromeVersions.length; k < len1; k++) {
              ver = chromeVersions[k];
              paths.push(join(chromeVersionsDir, ver, internalFlashDir));
            }
            return paths.map(validatePath).filter(function(x) {
              return x;
            });
          }
        } catch (error1) {
          return null;
        }
        break;
      default:
        return null;
    }
  };

  findSystemFlashPath = function() {
    var error1, error2, systemFlashPath;
    try {
      systemFlashPath = app.getPath('pepperFlashSystemPlugin');
      fs.accessSync(systemFlashPath);
      return systemFlashPath;
    } catch (error1) {
      if (PLATFORM === 'darwin') {
        try {
          systemFlashPath = '/Library/Internet Plug-Ins/PepperFlashPlayer';
          fs.accessSync(systemFlashPath);
          return systemFlashPath;
        } catch (error2) {
          return null;
        }
      } else {
        return null;
      }
    }
  };

  getFlashVersion = function(loc) {
    var match, path, plistContent, plistPath;
    if (typeof loc !== 'string') {
      return '';
    }
    path = (function() {
      switch (loc.toLowerCase()) {
        case '@chrome':
          return findChromeFlashPath();
        case '@system':
          return findSystemFlashPath();
        default:
          return loc;
      }
    })();
    path = validatePath(path);
    if (!path) {
      return '';
    }
    switch (PLATFORM) {
      case 'darwin':
        plistPath = join(path, 'Contents', 'Info.plist');
        plistContent = fs.readFileSync(plistPath, 'utf8');
        match = /<key>CFBundleVersion<\/key>\s*<string>(\d+(?:\.\d+)*)<\/string>/.exec(plistContent);
        if (match && match.length > 1) {
          return match[1];
        } else {
          return '';
        }
        break;
      default:
        return '';
    }
  };

  getAllChromeFlashVersions = function() {
    var paths;
    paths = findChromeFlashPath(true);
    if (paths) {
      return paths.map(function(p) {
        return [getFlashVersion(p), p];
      });
    } else {
      return [];
    }
  };

  flashSources = [];

  usingIndex = -1;

  addSource = function(location, version) {
    var o;
    if (location == null) {
      location = '.';
    }
    if (typeof location === 'string') {
      o = {
        loc: location
      };
      if (version != null) {
        if (typeof version === 'string' && reVerNum.test(version)) {
          o.ver = version;
        } else {
          error("Invalid version string for " + location + ": " + version);
        }
      }
      flashSources.push(o);
    } else {
      error("'" + location + "' is not a valid location string!");
    }
    return this;
  };

  getPath = function(loc) {
    var errMsg, flashPath, i, j, len, src;
    if (loc != null) {
      switch (loc.toLowerCase()) {
        case '@chrome':
          flashPath = findChromeFlashPath();
          errMsg = 'Could not load Chrome integrated Pepper Flash Player plug-in';
          break;
        case '@system':
          flashPath = findSystemFlashPath();
          errMsg = 'Could not load Pepper Flash Player system plug-in';
          break;
        default:
          flashPath = loc;
          errMsg = "Could not load '" + FILENAME + "' from: \n" + loc;
      }
    } else {
      if (flashSources.length === 0) {
        errMsg = 'No source has been added. Please call `addSource()` to add the location where Flash Player can be found.';
      }
      for (i = j = 0, len = flashSources.length; j < len; i = ++j) {
        src = flashSources[i];
        flashPath = getPath(src.loc);
        usingIndex = i;
        if (flashPath != null) {
          break;
        }
      }
    }
    flashPath = validatePath(flashPath);
    if ((errMsg != null) && (flashPath == null)) {
      error(errMsg);
    }
    return flashPath;
  };

  load = function() {
    var flashPath, ver;
    flashPath = getPath();
    if (flashPath != null) {
      log("Loading Pepper Flash Player: \n" + (resolve(flashPath)));
      app.commandLine.appendSwitch('ppapi-flash-path', flashPath);
      ver = getFlashVersion(flashPath);
      if (usingIndex >= 0 && !ver) {
        ver = flashSources[usingIndex].ver;
      }
      if (ver) {
        log("Pepper Flash Player version: " + ver);
        return app.commandLine.appendSwitch('ppapi-flash-version', ver);
      }
    }
  };

  if (process.type === 'browser') {
    exports.addSource = addSource;
    exports.load = load;
  }

  exports.debug = debug;

  exports.getFilename = function() {
    return FILENAME;
  };

  exports.getVersion = getFlashVersion;

  exports.getAllChromeFlashVersions = getAllChromeFlashVersions;

}).call(this);
