'use strict';

exports.readContentTypesFromXml = readContentTypesFromXml;

const fallbackContentTypes = {
  png: 'png',
  gif: 'gif',
  jpeg: 'jpeg',
  jpg: 'jpeg',
  tif: 'tiff',
  tiff: 'tiff',
  bmp: 'bmp',
};

exports.defaultContentTypes = contentTypes({}, {});


function readContentTypesFromXml(element) {
  const extensionDefaults = {};
  const overrides = {};

  element.children.forEach(function(child) {
    if (child.name === 'content-types:Default') {
      extensionDefaults[child.attributes.Extension] = child.attributes.ContentType;
    }
    if (child.name === 'content-types:Override') {
      let name = child.attributes.PartName;
      if (name.charAt(0) === '/') {
        name = name.substring(1);
      }
      overrides[name] = child.attributes.ContentType;
    }
  });
  return contentTypes(overrides, extensionDefaults);
}

function contentTypes(overrides, extensionDefaults) {
  return {
    findContentType(path) {
      if (!path) {
        return null;
      }
      const overrideContentType = overrides[path];
      if (overrideContentType) {
        return overrideContentType;
      }
      const pathParts = path.split('.');
      const extension = pathParts[pathParts.length - 1];
      if (extensionDefaults.hasOwnProperty(extension)) {
        return extensionDefaults[extension];
      }
      const fallback = fallbackContentTypes[extension.toLowerCase()];
      if (fallback) {
        return 'image/' + fallback;
      }
      return null;
    },
  };
}
